/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.BusyException;
import com.ibm.hwmca.fw.rbf.HandlerNotRegisteredException;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rbf.impl.CancelMsg;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.HandlerThread;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.persist.HandleResponsePersistencePMImpl;
import com.ibm.hwmca.fw.rbf.impl.persist.RbfHandleResponsePersistence;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RequestHandlingManager {
    private static final String TRACE_MASKT = "XRBFRHMT";
    private static final String TRACE_MASKF = "XRBFRHMF";
    private static final String TRACE_MASKD = "XRBFRHMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-RqHdlMgr");
    private static final int HANDLING_MAX = 30;
    private static final int QUEUE_MAX = 150;
    private static RequestHandlingManager RequestHandlingManager = null;
    private static RbfHandleResponsePersistence responsePersistence = null;
    private static LinkedList queue = new LinkedList();
    private static Map handling = new HashMap();
    private static Object requestsLock = new Object();

    private RequestHandlingManager() {
        try {
            responsePersistence.removeResponses(responsePersistence.loadResponses());
        }
        catch (RbfException rbfException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<> RequestHandlingManager()");
    }

    public static synchronized RequestHandlingManager getRequestHandlingManager() throws PersistenceNotInitializedException {
        return com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getRequestHandlingManager(null);
    }

    static synchronized RequestHandlingManager getRequestHandlingManager(RbfHandleResponsePersistence responsePersistence) throws PersistenceNotInitializedException {
        if (RequestHandlingManager == null) {
            if (responsePersistence == null) {
                String msg = "Handle response persistence not specified";
                throw new PersistenceNotInitializedException(msg);
            }
            com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.responsePersistence = responsePersistence;
            RequestHandlingManager = new RequestHandlingManager();
        }
        return RequestHandlingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void provideHandling(RbfRequest request) throws RbfException {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> provideHandling() " + requestId);
        Object object = requestsLock;
        synchronized (object) {
            RbfRequestType reqType = request.getType();
            if (HandlerManager.getHandlerManager().getLocalHandlerClass(reqType) == null) {
                String msg = "No locally registered handler class for " + reqType;
                Trace.trace(TRACE_MASKF, msg);
                throw new HandlerNotRegisteredException(msg);
            }
            if (handling.containsKey(request)) {
                RbfRequest handlingRequest = this.getHandlingRequest(requestId);
                if (handlingRequest.getState() == 20) {
                    if (!queue.contains(request)) {
                        if (queue.size() >= 150) throw new BusyException("Maximum queue size (150) exceeded");
                        queue.add(request);
                        Trace.trace(TRACE_MASKF, "Request queued");
                    } else {
                        Trace.trace(TRACE_MASKF, "Request already queued");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Request already being handled");
                }
            } else if (!queue.contains(request)) {
                if (handling.size() < 30) {
                    Trace.trace(TRACE_MASKF, "Handling the request immediately");
                    HandlerThread handlerThread = new HandlerThread(request);
                    handling.put(request, handlerThread);
                    handlerThread.start();
                } else {
                    if (queue.size() >= 150) throw new BusyException("Maximum queue size (150) exceeded");
                    queue.add(request);
                    Trace.trace(TRACE_MASKF, "Request queued");
                }
            } else {
                Trace.trace(TRACE_MASKF, "Request already queued");
            }
            Trace.trace(TRACE_MASKD, com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getHandlingDump());
            Trace.trace(TRACE_MASKD, com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getQueueDump());
            Trace.trace(TRACE_MASKF, handling.size() + " handled requests");
            Trace.trace(TRACE_MASKF, queue.size() + " queued requests");
        }
        Trace.trace(TRACE_MASKT, "<- provideHandling() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean terminateHandling(RbfRequestId requestId) {
        Trace.trace(TRACE_MASKT, "-> terminateHandling() " + requestId);
        boolean terminated = false;
        HandlerThread handlerThread = null;
        Object object = requestsLock;
        synchronized (object) {
            RbfRequest request = this.getQueuedRequest(requestId);
            if (request != null) {
                queue.remove(request);
            }
            if ((request = this.getHandlingRequest(requestId)) != null) {
                handlerThread = (HandlerThread)handling.get(request);
            }
        }
        if (handlerThread != null) {
            handlerThread.terminateAsync();
        } else {
            terminated = true;
        }
        Trace.trace(TRACE_MASKT, "<- terminateHandling() " + requestId);
        return terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedHandling(RbfRequest request) {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> finishedHandling() " + requestId);
        Object object = requestsLock;
        synchronized (object) {
            handling.remove(request);
            if (queue.size() > 0) {
                RbfRequest nextRequest = null;
                Iterator queued = queue.iterator();
                while (queued.hasNext()) {
                    nextRequest = (RbfRequest)queued.next();
                    if (handling.containsKey(nextRequest)) continue;
                    queue.remove(nextRequest);
                    HandlerThread handlerThread = new HandlerThread(nextRequest);
                    handling.put(nextRequest, handlerThread);
                    handlerThread.start();
                    break;
                }
                if (nextRequest == null) {
                    Trace.trace(TRACE_MASKF, "All queued requests have handling pending");
                }
            }
            Trace.trace(TRACE_MASKD, com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getHandlingDump());
            Trace.trace(TRACE_MASKD, com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getQueueDump());
            Trace.trace(TRACE_MASKF, handling.size() + " handled requests");
            Trace.trace(TRACE_MASKF, queue.size() + " queued requests");
        }
        Trace.trace(TRACE_MASKT, "<- finishedHandling() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHandlingDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Request handling manager handling:\n");
        Object object = requestsLock;
        synchronized (object) {
            if (handling.isEmpty()) {
                sb.append("1. Empty");
            } else {
                int index = 1;
                Iterator iterator = handling.keySet().iterator();
                while (iterator.hasNext()) {
                    RbfRequest request = (RbfRequest)iterator.next();
                    if (index == 1) {
                        sb.append(index + ". " + request.getIdentifier());
                    } else {
                        sb.append("\n" + index + ". " + request.getIdentifier());
                    }
                    ++index;
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getQueueDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Request handling manager queue:\n");
        Object object = requestsLock;
        synchronized (object) {
            if (queue.isEmpty()) {
                sb.append("1. Empty");
            } else {
                int index = 1;
                Iterator iterator = queue.iterator();
                while (iterator.hasNext()) {
                    RbfRequest request = (RbfRequest)iterator.next();
                    if (index == 1) {
                        sb.append(index + ". " + request.getIdentifier());
                    } else {
                        sb.append("\n" + index + ". " + request.getIdentifier());
                    }
                    ++index;
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RbfRequest getRequest(RbfRequestId requestId) {
        if (requestId == null) {
            return null;
        }
        RbfRequest request = null;
        Object object = requestsLock;
        synchronized (object) {
            request = this.getQueuedRequest(requestId);
            if (request == null) {
                request = this.getHandlingRequest(requestId);
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RbfRequest getQueuedRequest(RbfRequestId requestId) {
        if (requestId == null) {
            return null;
        }
        RbfRequest request = null;
        Object object = requestsLock;
        synchronized (object) {
            Iterator iterator = queue.iterator();
            while (iterator.hasNext() && request == null) {
                RbfRequest candidate = (RbfRequest)iterator.next();
                if (!candidate.getIdentifier().equals(requestId)) continue;
                request = candidate;
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RbfRequest getHandlingRequest(RbfRequestId requestId) {
        if (requestId == null) {
            return null;
        }
        RbfRequest request = null;
        Object object = requestsLock;
        synchronized (object) {
            Iterator iterator = handling.keySet().iterator();
            while (iterator.hasNext() && request == null) {
                RbfRequest candidate = (RbfRequest)iterator.next();
                if (!candidate.getIdentifier().equals(requestId)) continue;
                request = candidate;
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getAllRequests() {
        Object object = requestsLock;
        synchronized (object) {
            ArrayList requests = new ArrayList(handling.keySet());
            requests.addAll(queue);
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(RbfRequest request) {
        final RbfRequestId theRequestId = request.getIdentifier();
        final RequestTrackingData theTrackingData = request.getTrackingData();
        Trace.trace(TRACE_MASKT, "-> cancel() " + theRequestId);
        boolean doit = false;
        RequestTrackingData requestTrackingData = theTrackingData;
        synchronized (requestTrackingData) {
            if (theTrackingData.isStateChangeValid(theTrackingData.state, 12)) {
                theTrackingData.state = 12;
                theTrackingData.canceled = true;
                doit = true;
            }
        }
        if (doit) {
            Thread cancelThread = new Thread(new Runnable(){

                public void run() {
                    Trace.trace(com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.TRACE_MASKT, "-> Async cancelation " + theRequestId);
                    try {
                        RequestHandlingManager;
                        RequestHandlingManager rhMgr = com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getRequestHandlingManager();
                        rhMgr.terminateHandling(theRequestId);
                    }
                    catch (PersistenceNotInitializedException pnie) {
                        // empty catch block
                    }
                    try {
                        CommManager commMgr = CommManager.getCommManager();
                        CancelMsg msg = new CancelMsg(theRequestId);
                        RbfReply rbfReply = commMgr.send(msg, theTrackingData.getOrigin());
                    }
                    catch (RbfException rbfException) {
                        // empty catch block
                    }
                    Trace.trace(com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.TRACE_MASKT, "<- Async cancelation " + theRequestId);
                }
            }, "RBF Cancel Thread " + theRequestId);
            cancelThread.start();
        }
        Trace.trace(TRACE_MASKT, "<- cancel() " + theRequestId);
    }

    RbfHandleResponse getHandleResponse(RbfRequestId requestId) {
        RbfHandleResponse response = null;
        try {
            response = responsePersistence.loadResponse(requestId);
        }
        catch (RbfException rbfException) {
            // empty catch block
        }
        return response;
    }

    void storeHandleResponse(RbfHandleResponse response) {
        try {
            responsePersistence.storeResponse(response);
        }
        catch (RbfException rbfException) {
            // empty catch block
        }
    }

    void removeHandleResponse(RbfHandleResponse response) {
        try {
            responsePersistence.removeResponse(response);
        }
        catch (RbfException rbfException) {
            // empty catch block
        }
    }

    void fcsStateChanged(FcsEvent event) {
        int type = event.getEventType();
        int details = event.getEventDetails();
        MachineId machine = event.getMachineId();
        String machineInfo = RbfUtils.getMachineInfo(machine);
        if (type == 1 && details == 54) {
            this.machineChanged(machine, event.getOldMachineId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void machineChanged(MachineId machine, MachineId oldMachine) {
        Iterator all = this.getAllRequests().iterator();
        while (all.hasNext()) {
            RequestTrackingData trackingData;
            RbfRequest request = (RbfRequest)all.next();
            RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
            synchronized (requestTrackingData) {
                if (oldMachine.equals(trackingData.origin)) {
                    trackingData.origin = machine;
                }
                if (oldMachine.equals(trackingData.handler)) {
                    trackingData.handler = machine;
                }
                if (trackingData.handlerSubset != null && trackingData.handlerSubset.remove(oldMachine)) {
                    trackingData.handlerSubset.add(machine);
                }
            }
        }
    }

    static {
        try {
            com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager.getRequestHandlingManager(new HandleResponsePersistencePMImpl());
        }
        catch (PersistenceNotInitializedException pnie) {
            String desc = "Internal error: " + pnie.getClass().getName() + " during static initialization:\n" + RbfUtils.getStackTrace(pnie);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1061);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo());
            fl.log();
        }
    }
}

